/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.SliderEpochTool;
import cds.aladin.Source;
import cds.aladin.Tag;
import cds.aladin.prop.PropPanel;
import cds.astro.Astrocoo;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Unit;
import cds.tools.Computer;
import cds.tools.Util;
import cds.xml.TableParser;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameCooToolbox
extends JFrame {
    protected Aladin aladin;
    private boolean init = false;
    private double ra;
    private double dec;
    private double originEpoch = 2000.0;
    private double pmra = 0.0;
    private double pmdec = 0.0;
    private double rv = 0.0;
    private double plx = 0.0;
    private double targetEpoch = 2000.0;
    private int precision = -1;
    private JTextField[] cooField;
    private JTextField pmraField;
    private JTextField pmdeField;
    private JTextField originEpochField;
    private JTextField targetEpochField;
    private JTextField distField;
    private JTextField plxField;
    private JTextField rvField;
    private JTextField distALField;
    private JTextField distParsecField;
    private SliderEpochTool sliderEpoch;
    private JComboBox<String> precisionField;
    private static String[] PREC_S = new String[]{"unknown", "1degree", "0.1degree", "1arcmin", "0.1arcmin", "1arcsec", "0.1arcsec", "10mas", "1mas", "0.1mas", "10\u00b5as", "1\u00b5as", "0.1\u00b5as", "0.01\u00b5as"};
    private static int[] PREC_VAL = new int[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private static double PARSEC2AL = 3.2614945566008;

    protected FrameCooToolbox(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle(Aladin.chaine.getString("COOTOOL"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.getContentPane().add((Component)this.createPanelLeft(), "West");
        this.getContentPane().add((Component)this.createPanelRight(), "East");
        this.getContentPane().add((Component)this.getPanelBottom(), "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.aladin.frameCooTool = null;
        }
        super.processWindowEvent(e);
    }

    private JPanel createPanelRight() {
        int n;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setLayout(g);
        for (n = 0; n < Localisation.REPERE.length && !Localisation.REPERE[n].startsWith("XY"); ++n) {
        }
        JLabel[] label = new JLabel[n];
        this.cooField = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            label[i] = new JLabel(Localisation.REPERE[i]);
            this.cooField[i] = new JTextField(38);
            this.cooField[i].setActionCommand(i + "");
            this.cooField[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameCooToolbox.this.setCoordFrom(e.getActionCommand(), ((JTextField)e.getSource()).getText());
                }
            });
            c.insets.top = i == 5 ? 10 : 0;
            PropPanel.addCouple(p, label[i], this.cooField[i], g, c);
        }
        return p;
    }

    protected JPanel getPanelBottom() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        JButton b = new JButton(Aladin.chaine.getString("TAGIT"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.tagit();
            }
        });
        b = new JButton(Aladin.chaine.getString("CLEAR"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.reset();
            }
        });
        b = new JButton(Aladin.chaine.getString("UPCLOSE"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.aladin.frameCooTool = null;
                FrameCooToolbox.this.dispose();
            }
        });
        return p;
    }

    private JPanel createPanelLeft() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setLayout(g);
        c.insets = new Insets(0, 0, 0, 0);
        JLabel pmraLabel = new JLabel("PMRA (mas/yr)");
        this.pmraField = new JTextField(10);
        this.pmraField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel pmdeLabel = new JLabel("PMDEC (mas/yr)");
        this.pmdeField = new JTextField(10);
        this.pmdeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel plxLabel = new JLabel("Parallax (mas)");
        this.plxField = new JTextField(10);
        this.plxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel distParsecLabel = new JLabel("Dist (parsec)");
        this.distParsecField = new JTextField(10);
        this.distParsecField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify(2);
            }
        });
        JLabel distALLabel = new JLabel("Dist (light-year)");
        this.distALField = new JTextField(10);
        this.distALField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify(1);
            }
        });
        JLabel rvLabel = new JLabel("Radial velocity (km/s)");
        this.rvField = new JTextField(10);
        this.rvField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel originEpochLabel = new JLabel("Origin epoch (Jy)");
        this.originEpochField = new JTextField(10);
        this.originEpochField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel currentEpochLabel = new JLabel("Target epoch (Jy)");
        this.targetEpochField = new JTextField(10);
        this.targetEpochField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        JLabel precisionLabel = new JLabel("Precision");
        this.precisionField = new JComboBox<String>(PREC_S);
        this.precisionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameCooToolbox.this.modify();
            }
        });
        this.sliderEpoch = new SliderEpochTool(this);
        PropPanel.addCouple(p, pmraLabel, this.pmraField, g, c);
        PropPanel.addCouple(p, pmdeLabel, this.pmdeField, g, c);
        PropPanel.addCouple(p, plxLabel, this.plxField, g, c);
        PropPanel.addCouple(p, distParsecLabel, this.distParsecField, g, c);
        PropPanel.addCouple(p, distALLabel, this.distALField, g, c);
        PropPanel.addCouple(p, rvLabel, this.rvField, g, c);
        PropPanel.addCouple(p, originEpochLabel, this.originEpochField, g, c);
        PropPanel.addCouple(p, currentEpochLabel, this.targetEpochField, g, c);
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        g.setConstraints(this.sliderEpoch, c);
        p.add(this.sliderEpoch);
        JLabel distLabel = new JLabel("Ang.dist. from orig.loc");
        this.distField = new JTextField(10);
        this.distField.setEditable(false);
        PropPanel.addCouple(p, distLabel, this.distField, g, c);
        PropPanel.addCouple(p, precisionLabel, this.precisionField, g, c);
        return p;
    }

    protected void setSource(Source s) {
        block9: {
            Legende leg = s.getLeg();
            int nra = leg.getRa();
            int ndec = leg.getDe();
            if (nra == -1 && ndec == -1) {
                return;
            }
            String sra = s.getValue(nra);
            String sdec = s.getValue(ndec);
            int unit = TableParser.getUnit(leg.getUnit(nra));
            try {
                Astrocoo c = new Astrocoo();
                TableParser.getRaDec(c, sra, sdec, 0, unit);
                this.ra = c.getLon();
                this.dec = c.getLat();
                this.pmdec = 0.0;
                this.pmra = 0.0;
                int npmra = leg.getPmRa();
                int npmde = leg.getPmDe();
                if (npmra <= 0 || npmde <= 0) break block9;
                Unit mu1 = new Unit();
                try {
                    mu1.setUnit(Util.adjustFoxUnit(s.getUnit(npmra)));
                    mu1.setValue(s.getValue(npmra));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Unit mu2 = new Unit();
                try {
                    mu2.setUnit(Util.adjustFoxUnit(s.getUnit(npmde)));
                    mu2.setValue(s.getValue(npmde));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mu1.getValue() == 0.0 && mu2.getValue() == 0.0 || Double.isNaN(mu1.getValue()) || Double.isNaN(mu2.getValue())) break block9;
                try {
                    mu1.convertTo(new Unit("mas/yr"));
                }
                catch (Exception e) {
                    mu1.setUnit(Util.adjustFoxUnit(s.getUnit(npmra)));
                    mu1.setValue(s.getValue(npmra));
                    mu1.convertTo(new Unit("ms/yr"));
                    double v = 15.0 * mu1.getValue() * Math.cos(c.getLat() * Math.PI / 180.0);
                    mu1 = new Unit(v + "mas/yr");
                }
                this.pmra = mu1.getValue();
                mu2.convertTo(new Unit("mas/yr"));
                this.pmdec = mu2.getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.originEpoch = s.plan.getOriginalEpoch().getJyr();
        this.targetEpoch = s.plan.getEpoch().getJyr();
        this.init = true;
        this.resume();
    }

    protected void setReticle(double ra, double dec) {
        this.ra = ra;
        this.dec = dec;
        this.targetEpoch = 2000.0;
        this.originEpoch = 2000.0;
        try {
            String ep;
            Plan pi = this.aladin.calque.getPlanBase();
            if (pi instanceof PlanImage && (ep = ((PlanImage)pi).getDateObs()) != null) {
                Astrotime t = new Astrotime();
                t.set(ep);
                this.originEpoch = t.getJyr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pmdec = 0.0;
        this.pmra = 0.0;
        this.init = true;
        this.resume(false);
    }

    protected void setCoordFrom(String sFrameSource, String s) {
        try {
            int frameSource = Integer.parseInt(sFrameSource);
            Astrocoo aft = new Astrocoo(Localisation.getAstroframe(frameSource));
            if (s.indexOf(40) < 0 && this.originEpochField.getText().trim().length() > 0) {
                s = s + " (J" + this.originEpochField.getText().trim() + ")";
            }
            aft.set(s);
            aft.convertTo(Localisation.getAstroframe(0));
            this.originEpochField.setText(aft.epoch + "");
            this.targetEpochField.setText(aft.epoch + "");
            this.precision = -1;
            this.ra = aft.getLon();
            this.dec = aft.getLat();
            this.init = true;
            this.modify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void modify() {
        this.modify(0);
    }

    protected void modify(int from) {
        String s;
        try {
            s = this.originEpochField.getText();
            if (Character.isDigit(s.charAt(0))) {
                s = "J" + s;
            }
            this.originEpoch = new Astrotime(s).getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = this.targetEpochField.getText();
            if (Character.isDigit(s.charAt(0))) {
                s = "J" + s;
            }
            this.targetEpoch = new Astrotime(s).getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.precision = PREC_VAL[this.precisionField.getSelectedIndex()];
        }
        catch (Exception e) {
            this.precision = -1;
        }
        try {
            this.pmra = this.getField(this.pmraField);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.pmdec = this.getField(this.pmdeField);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (from == 2) {
                double d = this.getField(this.distParsecField);
                this.plx = this.arsec2plx(d);
            } else if (from == 1) {
                double d = this.getField(this.distALField);
                this.plx = this.al2plx(d);
            } else {
                this.plx = this.getField(this.plxField);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rv = this.getField(this.rvField);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume();
        this.moveRepere();
    }

    private void tagit() {
        try {
            PlanTool plan = this.aladin.calque.selectPlanTool();
            Coord coo = this.getCoordInICRS();
            Tag tag = new Tag(plan, coo, null);
            this.aladin.calque.updateToolCatTag(tag, this.aladin.view.getCurrentView());
            this.aladin.view.gotoThere(coo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double getField(JTextField field) throws Exception {
        String s = field.getText();
        return Computer.compute(s);
    }

    protected void setEpoch(String s) {
        try {
            if (Character.isDigit(s.charAt(0))) {
                s = "J" + s;
            }
            this.targetEpoch = new Astrotime(s).getJyr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resume(false);
    }

    private void resume() {
        this.resume(true);
    }

    private void resume(boolean flagLog) {
        if (this.cooField == null) {
            return;
        }
        for (int i = 0; i < this.cooField.length; ++i) {
            this.cooField[i].setText(this.getCoordIn(i));
        }
        this.originEpochField.setText(!this.init ? "" : this.originEpoch + "");
        this.targetEpochField.setText(!this.init ? "" : this.targetEpoch + "");
        this.pmraField.setText(!this.init ? "" : (this.pmdec == 0.0 && this.pmra == 0.0 ? "" : Util.myRound(this.pmra + "", 3)));
        this.pmdeField.setText(!this.init ? "" : (this.pmdec == 0.0 && this.pmra == 0.0 ? "" : Util.myRound(this.pmdec + "", 3)));
        this.rvField.setText(!this.init ? "" : (this.rv == 0.0 ? "" : Util.myRound(this.rv + "", 3)));
        this.plxField.setText(!this.init ? "" : this.getParallaxe());
        this.distField.setText(this.getDistance());
        this.distALField.setText(this.getDistAL());
        this.distParsecField.setText(this.getDistParsec());
        this.sliderEpoch.setValue((int)this.targetEpoch);
        if (flagLog) {
            this.aladin.glu.log("CoordToolbox", "");
        }
    }

    private void reset() {
        this.init = false;
        this.resume(false);
        this.precision = -1;
        this.precisionField.setSelectedIndex(0);
    }

    private void moveRepere() {
        try {
            Coord coo = this.getCoordInICRS();
            this.aladin.view.gotoThere(coo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDistAL() {
        if (this.plx == 0.0) {
            return "";
        }
        return Util.myRound(1000.0 * PARSEC2AL / this.plx);
    }

    private String getDistParsec() {
        if (this.plx == 0.0) {
            return "";
        }
        return Util.myRound(1000.0 / this.plx);
    }

    private double al2plx(double al) {
        return 1000.0 * PARSEC2AL / al;
    }

    private double arsec2plx(double p) {
        return 1000.0 / p;
    }

    private String getParallaxe() {
        if (this.plx == 0.0) {
            return "";
        }
        if (this.targetEpoch == this.originEpoch || this.rv == 0.0) {
            return this.plx + "";
        }
        Astropos targetCoo = new Astropos(Localisation.AF_ICRS);
        targetCoo.set(this.ra, this.dec, this.originEpoch, null, this.pmra, this.pmdec, this.originEpoch, null, new double[]{this.plx, 0.0}, new double[]{this.rv, 0.0});
        if (this.precision > -1) {
            targetCoo.setPrecision(this.precision);
        }
        targetCoo.toEpoch(this.targetEpoch);
        return Util.myRound("" + targetCoo.plx, 6);
    }

    private String getDistance() {
        if (!this.init || this.targetEpoch == this.originEpoch || this.pmra == 0.0 && this.pmdec == 0.0) {
            return "";
        }
        Astropos targetCoo = new Astropos(Localisation.AF_ICRS);
        targetCoo.set(this.ra, this.dec, this.originEpoch, null, this.pmra, this.pmdec, this.originEpoch, null, new double[]{this.plx, 0.0}, new double[]{this.rv, 0.0});
        if (this.precision > -1) {
            targetCoo.setPrecision(this.precision);
        }
        targetCoo.toEpoch(this.targetEpoch);
        double d = Coo.distance(this.ra, this.dec, targetCoo.getLon(), targetCoo.getLat());
        return Coord.getUnit(d);
    }

    private Coord getCoordInICRS() {
        Astropos targetCoo = new Astropos(Localisation.AF_ICRS);
        targetCoo.set(this.ra, this.dec, this.originEpoch, null, this.pmra, this.pmdec, this.originEpoch, null, new double[]{this.plx, 0.0}, new double[]{this.rv, 0.0});
        if (this.precision > -1) {
            targetCoo.setPrecision(this.precision);
        }
        targetCoo.toEpoch(this.targetEpoch);
        Coord coo = new Coord(targetCoo.getLon(), targetCoo.getLat());
        return coo;
    }

    private String getCoordIn(int frameTarget) {
        String s;
        double[] dArray;
        double[] dArray2;
        if (!this.init) {
            return "";
        }
        Astropos targetCoo = new Astropos(Localisation.AF_ICRS);
        if (this.plx == 0.0) {
            dArray2 = null;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = this.plx;
            dArray2 = dArray3;
            dArray3[1] = 0.0;
        }
        double[] plxParam = dArray2;
        if (this.rv == 0.0) {
            dArray = null;
        } else {
            double[] dArray4 = new double[2];
            dArray4[0] = this.rv;
            dArray = dArray4;
            dArray4[1] = 0.0;
        }
        double[] rvParam = dArray;
        double pmraParam = this.pmra == 0.0 ? Double.NaN : this.pmra;
        double pmdecParam = this.pmdec == 0.0 ? Double.NaN : this.pmdec;
        targetCoo.set(this.ra, this.dec, this.originEpoch, null, pmraParam, pmdecParam, this.originEpoch, null, plxParam, rvParam);
        if (this.precision > -1) {
            targetCoo.setPrecision(this.precision);
        }
        targetCoo.toEpoch(this.targetEpoch);
        if (frameTarget != 0 && frameTarget != 1) {
            targetCoo.convertTo(Localisation.getAstroframe(frameTarget));
        }
        String string = s = frameTarget == 6 || frameTarget == 8 || frameTarget == 1 || frameTarget == 2 || frameTarget == 3 || frameTarget == 4 ? targetCoo.toString("2d") : targetCoo.toString("2s");
        if (s.indexOf("--") >= 0) {
            return "";
        }
        return s;
    }
}

